/**
* @author: Inkbunny - Kogentasama
* @since: 2010-09-05
* @copyright: 2010 Inkbunny.net
* @license: GPL V3.0 http://www.gnu.org/licenses/gpl-3.0.html
* 
* This Software is distributed under the terms of the GNU General Publix License.
* 
* This file is part of "Inkbunny api plugin".
*
*   "Inkbunny api plugin" is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation, either version 3 of the License, or
*   (at your option) any later version.
*
*   "Inkbunny api plugin" is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with "Inkbunny api plugin".  If not, see <http://www.gnu.org/licenses/>.
**/

$(document).ready(function() {
	
	$.inkbunny = new Object;
	$.inkbunny.session = 'empty'; // where the IB session will be stored
	$.inkbunny.url = 'https://inkbunny.net/';
	$.inkbunny.username = 'guest';
	$.inkbunny.password = '';
	
	// has to be in this closure so no other code can be pushed into this
	var function_queue = new Array;
	
	// where we wanna fetch images from, your username go here
	$.inkbunny.search_username = 'kogentasama';
	
	// this is the ID of the container where the images will be put in
	$.inkbunny.element = $('#ib_latest_images');
	
	// ## QUEUE ##
	// ## JSONP can not be called synchronously so we have to fake it
	
	/**
	 * calls next function in queue
	 */
	call_next = function() {
		var functioncall = function_queue.shift();
		if (functioncall) {
			eval(functioncall);
			
			// debug info for firebug
			if (typeof console != 'undefined') {
				console.log('['+functioncall+'] called');
			}
		}
	};
	
	/**
	 * adds function to queue
	 */
	add_func = function(functioncall) {
		function_queue.push(functioncall);
	};
	
	// ## INKBUNNY FUNCTIONS ##
	
	/**
	 * connects to IB and fetches a session_id
	 */
	connect = function() {
		$.inkbunny.element.html('fetching session ...');
		
		// data being send to Inkbunny
		var senddata = new Object;
		senddata.username = 'guest';
		senddata.password = '';
		senddata.output_mode = 'json';
		
		// url to be called
		var call_url = $.inkbunny.url + 'api_login.php';
		
		// fetch it
		$.ajax({
			dataType: 'jsonp',
			data: senddata,
			jsonp: 'callback',
			url: call_url,
			type: 'get',
			success: function (data) {
				$.inkbunny.session = data.sid;
				call_next();
				// debug info for firebug
				if (typeof console != 'undefined') {
					console.log($.inkbunny.session);
				}
			}
		});
	};
	
	/**
	 * Make a search request to inkbunny
	 */
	fetch_last_five = function(username) {
		$.inkbunny.element.html('loading ...');
		
		// data being send to inkbunny
		var senddata = new Object;
		senddata.output_mode = 'json';
		senddata.sid = $.inkbunny.session;
		
		senddata.username = username;
		senddata.orderby = 'views';
		senddata.submissions_per_page = 10;
		
		// url to be called
		var call_url = $.inkbunny.url + 'api_search.php';
		
		// where the submissions will be put in
		var submissions = new Object;
		
		$.ajax({
			dataType: 'jsonp',
			data: senddata,
			jsonp: 'callback',
			url: call_url,
			type: 'get',
			success: function (data) {
				submissions = data.submissions;
				call_next();
			}
		});
		
		/**
		 * This function shows the images found
		 */
		show_submissions = function() {
			if (typeof console != 'undefined') {
				console.log(submissions);
			}
			
			$.inkbunny.element.html('');
			
			// iterate through the submissions
			$.each(submissions, function(element, value) {
				var item = '';
				item += '<a target="_blank" href="http://inkbunny.net/submissionview.php?id='+value.submission_id+'">';
				item += '<img class="ib_thumbnail" src="'+value.thumbnail_url_medium+'" />';
				item += '</a>';
				
				$.inkbunny.element.append(item);
			});
			call_next();
		};
	};
	
	connect();
	// add first function to queue
	// conenct will call it as soon as it got an session id
	add_func('fetch_last_five($.inkbunny.search_username);');
	add_func('show_submissions();');
	
});